﻿var version = 1.5;
/*	VERSION: 1.5
1.5		Changed the change_var event to occur after the value is applied to the variable.
			Added a preChange_var event for reacting before the value is applied
1.4		Added "announceInitialValue" parameter
1.3		Check for watch() failure
1.2		Event reactions can modify the impending evt.value before it's applied.  This makes it possible to prevent a variable's value from actually changing, for example.
1.1		Added optional "alwaysFire" flag so variable assignments are always announced even when the value doesn't change.

USAGE: 
	#include "functions/announceChanges.as"
	myVar = false;
	announceChanges( "myVar" );
	react.to("change_myVar").then = function( evt ){
		trace( "myVar is " + evt.value );
	}
	
	myVar = true;
*/
_this = _this || this;
#include "functions/eventSystem3.as"
if(!_this.addListener)		AsBroadcaster.initialize( _this );
if(!react)								var react = make_react( _this );		// param is optional
function onUnload(){
	sendEvent( "unload" );		// this will trigger react.unload()		... and trigger any external code listening for "unload" to occur here
}// onUnload()


function announceChanges( varName, alwaysFire, announceInitialValue ){
	// default values of optional parameters
	if( alwaysFire === undefined )
		alwaysFire = false;
	if( announceInitialValue === undefined )
		announceInitialValue = true;
		
	var watchCreated = _this.watch( varName, function( varName, oldValue, newValue ){
		var evt = {value: newValue};
		if( alwaysFire  ||  newValue !== oldValue ){
			// announce before the change is applied
			sendEvent("preChange_"+varName, evt);
			// announce after the change is applied
			setTimeout(function(){
				sendEvent("change_"+varName, evt);
			}, 0);
		}
		return evt.value;
	} );
	
	if( watchCreated === false ){
		trace( "announceChanges() failed to watch " + varName );
		return;
	}
	
	react.to("unload").then = function(){
		_this.unwatch( varName );
	}
	// init => announce initial value
	if( announceInitialValue )
	{// if:  announceInitialValue is true (default)
		react.to("init").then = function(){
			sendEvent("change_"+varName, {value: _this[varName]});
		}// init()
	}// if:  announceInitialValue is true (default)
}// announceChanges()

announceChanges.version = version;
version = null;
delete version;